# -*- coding: utf-8 -*-

from datetime import datetime

from passport.backend.core.logging_utils.loggers.tskv import (
    TskvLogEntry,
    TskvLogger,
)
from passport.backend.utils.time import (
    get_unixtime,
    unixtime_to_datetime,
)


class SocialBindingLogEntry(TskvLogEntry):
    DATETIME_FORMAT = '%d/%b/%Y:%H:%M:%S'

    def __init__(self, **params):
        params.setdefault('tskv_format', 'social-binding-log')
        params.setdefault('unixtime', get_unixtime())
        params['timestamp'] = self.format_timestamp(params['unixtime'])
        super(SocialBindingLogEntry, self).__init__(**params)

    @classmethod
    def format_timestamp(cls, timestamp=None):
        if timestamp is None:
            timestamp = datetime.now()
        elif not isinstance(timestamp, datetime):
            timestamp = unixtime_to_datetime(timestamp)
        return timestamp.strftime(cls.DATETIME_FORMAT)


class SocialBindingLogger(TskvLogger):
    default_logger_name = 'social_binding'
    entry_class = SocialBindingLogEntry


class BindPhonishAccountByTrackStatboxEvent(object):
    def __init__(
        self,
        ip,
        # Трек с подтверждением владения телефонным номером
        track_id,
        # Uid аккаунта, к которому нужно привязать фониша
        uid,
    ):
        self.ip = ip
        self.track_id = track_id
        self.uid = uid

    def asdict(self):
        return dict(
            action='bind_phonish_account_by_track',
            ip=self.ip,
            track_id=self.track_id,
            uid=self.uid,
        )

    def log(self, logger):
        logger.log(**self.asdict())
