# -*- coding: utf-8 -*-
from subprocess import (
    PIPE,
    Popen,
    STDOUT,
)

from passport.backend.core.conf import settings


class SendmailConnection(object):
    """
    Отправка сообщения через sendmail
    """
    def __init__(self):
        self.sendmail = settings.MAIL_SENDMAIL_PATH

    def send(self, message):
        """
        Отправить сообщение.

        @param message: сообщение для отправки
        @return код возврата команды sendmail
        """
        # Для корректного формирования заголовков DKIM явно сообщаем sendmail'у отправителя
        sendmail_flags = ['-t', '-f', message.from_address]
        sm = Popen(
            [self.sendmail] + sendmail_flags,
            stdin=PIPE,
            stdout=PIPE,
            stderr=STDOUT,
        )
        sm.stdin.write(message.as_string().encode('utf-8'))
        sm.communicate()

        return sm.returncode
