# -*- coding: utf-8 -*-
import logging

from passport.backend.core.lazy_loader import (
    lazy_loadable,
    LazyLoader,
)
from passport.backend.core.mailer.connection import SendmailConnection


log = logging.getLogger('passport.mailer.mailer')


@lazy_loadable('Mailer')
class Mailer(object):

    def __init__(self, connection_cls=SendmailConnection):
        """
        @param connection_cls: класс, организующий соединение и отправку почты
        """
        self.connection = connection_cls()

    def send(self, message):
        """
        Отправить сообщение.

        @param message: инстанс класса Message
        """
        return self.connection.send(message)


def send_message(message):
    """
    Отправка сообщения с простой обработкой исключений.

    @param message: Инстанс класса-сообщения для отправки
    @return: код завершения команды sendmail, None в случае исключения
    """
    result = None
    try:
        result = get_mailer().send(message)
    except Exception:
        log.exception('Exception during mail sending to %s', message.recipients)
    return result


def get_mailer():
    return LazyLoader.get_instance('Mailer')
