# -*- coding: utf-8 -*-

from passport.backend.utils.time import (
    parse_datetime,
    parse_unixtime,
)


def parse_datetime_field(field_name, **kwargs):
    def _parse(data, *args):
        value = parse_datetime(data.get(field_name), **kwargs)
        return value is not None, value

    return _parse


def parse_unixtime_field(field_name, **kwargs):
    def _parse(data, *args):
        value = parse_unixtime(data.get(field_name), **kwargs)
        return value is not None, value

    return _parse


def parse_boolean_field(field_name):
    def _parse(data, *args):
        value = data.get(field_name)

        if value in {'0', 0}:
            processed, value = True, False
        elif value in {'1', 1}:
            processed, value = True, True
        else:
            processed, value = False, None
        return processed, value
    return _parse


def parse_integer_field(field, default=None):
    def _parse(data, *args):
        try:
            return True, int(data.get(field, default))
        except (TypeError, ValueError):
            return False, None
    return _parse


def parse_list_field(field_name):
    def _parse(data, *args):
        _list = []
        value = data.get(field_name)
        if value:
            _list = value.split(';')
        return True, _list
    return _parse
