# -*- coding: utf-8 -*-

from passport.backend.core.models.base import Model
from passport.backend.core.models.base.fields import Field


OLD_TO_NEW = dict(
    ar='AM',
    be='BY',
    kr='KG',
    mo='MD',
    po='PL',
    tz='TJ',
    ge='DE',
    gg='GE',
    ch='CZ',
    sw='CH',
    lt='LV',
    lv='LT',
    notselected=''
)


class Country(Model):
    """
    Страна. Задается стандартным двухбуквенным кодом.
    Дефолтная таймзона.  Формируется на основе кода.
    Mapping между двумя стандартами: старым  и общим стандартом.
    """
    code = Field()
    # в итоге - upper-case
    # конвертация из lower по хешу выше

    # читабельное имя на английском
    name = Field()

    def __str__(self):
        return self.name
