# -*- coding: utf-8 -*-

from passport.backend.core.models.base import Model
from passport.backend.core.models.base.fields import Field


class DevicePublicKey(Model):
    device_id = Field('device_id')
    public_key = Field('public_key')
    version = Field('version')
    owner_id = Field('owner_id')

    def __eq__(self, other):
        if type(other) != DevicePublicKey:
            return False
        return (
            self.device_id == other.device_id and
            self.public_key == other.public_key and
            self.version == other.version and
            self.owner_id == other.owner_id
        )

    def __ne__(self, other):
        return not self.__eq__(other)
