# -*- coding: utf-8 -*-

from passport.backend.core.models.base import Model
from passport.backend.core.models.base.fields import Field
from passport.backend.utils.string import smart_bytes


class DriveSession(Model):
    # id машины
    drive_device_id = Field('drive_device_id')
    # id песочницы, где запускаются приложения (пересоздаётся при включении зажигания машины)
    sandbox_device_id = Field('sandbox_device_id')
    # id сессии (поездки)
    drive_session_id = Field('drive_session_id')
    uid = Field('uid')

    def is_same(self, other):
        if type(other) != DriveSession:
            return False
        return (
            self.drive_device_id == other.drive_device_id and
            # sandbox_device_id не сравниваем - он может меняться в рамках одной сессии
            self.drive_session_id == other.drive_session_id and
            self.uid == other.uid
        )

    def to_bytes(self):
        """Конкатенирует значения всех полей объекта, отсортированные по именам полей"""
        bits = [
            value or ''
            for key, value in sorted(self)
        ]
        return b''.join(smart_bytes(b) for b in bits)
