# -*- coding: utf-8 -*-
from passport.backend.core.eav_type_mapping import ALIAS_NAME_TO_TYPE as ALT
from passport.backend.core.models.account import Account


TEST_LOGIN = 'login'


def default_account(alias=TEST_LOGIN, alias_type='portal', **kwargs):
    acc = Account(**kwargs).parse({
        'login': alias,
        'aliases': {
            str(ALT[alias_type]): alias,
        },
    })
    if alias_type in ('portal', 'pdd'):
        acc.user_defined_login = alias.split('@')[0]
    return acc
