# -*- coding: utf-8 -*-

from passport.backend.core.models.base import Model
from passport.backend.core.models.base.fields import Field
from passport.backend.core.types.answer import normalize_answer
from passport.backend.core.types.question import Question
from passport.backend.core.undefined import Undefined


def _parse_question(data, *args):
    if 'userinfo_safe.hintq.uid' not in data:
        return False, None

    question = data['userinfo_safe.hintq.uid']
    if not question:
        return False, None

    if isinstance(question, Question):
        return True, question

    try:
        language = data.get('person.language', None)
        question = Question.parse(question, language=language)
    except ValueError:
        return False, None

    return True, question


class Hint(Model):
    """
    Контрольная пара вопрос-ответ.
    """
    parent = None

    question = Field(_parse_question)
    answer = Field('userinfo_safe.hinta.uid')

    def is_empty(self):
        return not self.is_set

    @property
    def is_set(self):
        return bool(self.question and self.answer)

    @property
    def normalized_answer(self):
        if self.answer is Undefined:
            return Undefined
        return normalize_answer(self.answer)
