# -*- coding: utf-8 -*-

from passport.backend.core.conf import settings
from passport.backend.core.models.base import Model
from passport.backend.core.models.base.fields import Field
from passport.backend.core.undefined import Undefined


def _parse_prefix(data, *args):
    if data.get('karma') is not None:
        return True, data['karma'] // 1000

    return False, None


def _parse_suffix(data, *args):
    if data.get('karma') is not None:
        return True, data['karma'] % 1000

    return False, None


class Karma(Model):
    """
    Состоит из 4 цифр, делится на две части: префикс и значение.
    Значение от 0 до 100. Сейчас градация 0,70,75,100.
    Сейчас 8 префиксов.
    На основании префикса и значения высиляются насколько плох/хорош юзер.
    """
    prefix = Field(_parse_prefix)
    suffix = Field(_parse_suffix)

    parent = None

    # Хранит timestamp, до которого нельзя отказывать юзеру в обслуживании,
    # даже если карма у него плохая.
    # Другими словами, когда начать включать ограничения, завязанные на карму.
    # Другими словами, когда применять карму.
    # Задается через acl_id поле
    activation_datetime = Field()

    def is_empty(self):
        return self.value is Undefined

    @property
    def value(self):
        if self.prefix is Undefined or self.suffix is Undefined:
            return Undefined

        return self.prefix * 1000 + self.suffix

    def is_washed(self):
        return self.prefix in [
            settings.KARMA_PREFIX_WASHED_BY_SUPPORT,
            settings.KARMA_PREFIX_WASHED,
        ]
