# -*- coding: utf-8 -*-
from passport.backend.core.types.phone_number.phone_number import (
    InvalidPhoneNumber,
    PhoneNumber,
)


def parse_phone_number_field(data, current_object, current_value, field_name):

    if field_name not in data:
        return False, None

    number = data[field_name]

    if isinstance(number, PhoneNumber):
        return True, number
    else:
        try:
            return True, PhoneNumber.parse(number, allow_impossible=True)
        except InvalidPhoneNumber:
            return True, number
