# -*- coding: utf-8 -*-
from passport.backend.core.models.base import Model
from passport.backend.core.models.base.fields import (
    BooleanField,
    Field,
)


class RfcTotpSecret(Model):
    """
    Модель секрета TOTP (RFC 6238)
    """
    parent = None

    # Важно: в ятиме НЕЛЬЗЯ полностью полагаться на is_set: информация, хранящаяся
    # в БД Периметра, приоритетней.
    # То есть, в ятиме возможны случаи, когда is_set=True, а фактически rfc_2fa выключена.
    is_set = BooleanField('account.rfc_2fa_on')  # виртуальный атрибут

    # Не читаем эти поля из ЧЯ на модель, т.к. их мы должны только писать
    totp_secret = Field()
    check_time = Field()

    def set(self, totp_secret):
        # totp_secret - объект типа RfcTotpSecretType
        self.totp_secret = totp_secret
        self.is_set = True
