# -*- coding: utf-8 -*-

"""
В каждой из подписок на определенный сид могут быть разные свойства.

Почтовая подписка:
Может быть логин который может отличаться от логина учетной записи.
Надо узнать что с точками и дефисами в почтовой подписке в логине.
У почты есть suid -  id записи в таблице.
host - отдельная сущность

"""
from passport.backend.core.models.base import Model
from passport.backend.core.models.base.fields import (
    Field,
    ModelField,
)
from passport.backend.core.models.base.parse import parse_datetime_field
from passport.backend.core.services import Service


def parse_service(data, *args):
    sid = data['sid']
    if isinstance(sid, Service):
        return True, sid
    service = Service.by_sid(sid)
    return True if service else False, service


class Host(Model):
    """
    http://doc.yandex-team.ru/Passport/mail-for-domain/api/host_def.xml
    """
    # обычно идентификатор в таблице hosts
    id = Field('host_id')

    name = Field()  # внутреннее, типа slug
    priority = Field()
    address = Field()  # TODO определить тип объекта


class Subscription(Model):
    """UPDATE в базу происходит по полям uid + sid"""
    parent = None  # ссылка на Account

    suid = Field('suid')
    host = ModelField(Host)

    # это не флаг, это статус
    # 0 - подписка задисейблена
    # 1 - незаблокирована
    # для некоторых подписок стаусов может быть больше

    # Нужно в будущем ввести статус, а от login_rule избавиться,
    # потому, что есть простые статус почти на всех подписках
    # Так же есть список более сложных статус для народа, народ2, диск, которые можно формализовать.
    # Но остается большая проблема с сервисом такси,
    # который будет хранить в login rule неизвестные нам числа для сохранения моделей телефонов пользователей,
    # то есть пока  мы не знаем принцип сериализации.
    login_rule = Field('login_rule')

    login = Field('login')

    service = Field(parse_service)  # сущность сервис
    # ДАТА создания с точностью до дня - Subclass(date)
    created_date = Field(parse_datetime_field('born_date', date_only=True))

    @property
    def sid(self):
        return self.service.sid

    @property
    def database_login(self):
        """Возвращает подходящее значение для записи в бд для поля login.

        `uid` для lite пользователей и для сервисов, у которых задан флаг .stores_uid_in_login.
        `login`@`domain` для пдд пользователей.
        `login` для всех остальных.

        """
        # TODO: как только перейдём на новую схему базы, надо пересмотреть работу в этом месте
        if self.login:
            return self.login
        elif self.service.sid == 8:
            # Происходит при создании аккаунта, записываем логин, как его ввёл пользователь
            return self.parent.login
        elif self.service.stores_not_uid_in_login:
            if self.parent.is_pdd:
                return self.parent.normalized_login + '@' + self.parent.domain.domain.lower()
            return self.parent.normalized_login
        else:
            return self.parent.uid


def build_sid_property(account_getter):
    """Принимаем функцию getter, возвращающую аккаунт, и строим property"""
    def sid_property(sid):
        def get_sid(self):
            subscriptions = account_getter(self).subscriptions
            return bool(subscriptions) and (sid in subscriptions) and (subscriptions[sid].service.sid == sid)

        def set_sid(self, value):
            parent = account_getter(self)
            if value:
                subscribe(parent, Subscription(parent).parse({'sid': sid}))
            else:
                unsubscribe(parent, sid)

        return property(get_sid, set_sid)

    return sid_property


def subscribe(account, subscription):
    account.subscriptions[subscription.service.sid] = subscription


def unsubscribe(account, sid):
    # PASSP-8985 Разрешено удаление блокирующих сидов в режимах работы
    # с подпиской на сервис, то есть через admsubscribe и /1/account/<uid>/subscription/.
    if sid in account.subscriptions:
        del account.subscriptions[sid]
