# -*- coding: utf-8 -*-

from passport.backend.core.models.base import Model
from passport.backend.core.models.base.fields import Field


class SupportCode(Model):
    value = Field('value')
    expires_at = Field('expires_at')
    uid = Field('uid')

    def __eq__(self, other):
        if type(other) != SupportCode:
            return False
        return (
            self.value == other.value and
            self.expires_at == other.expires_at and
            self.uid == other.uid
        )

    def __ne__(self, other):
        return not self.__eq__(other)
