# -*- coding: utf-8 -*-
from passport.backend.core.models.base import Model
from passport.backend.core.models.base.fields import (
    BooleanField,
    Field,
    UnixtimeField,
)


class Takeout(Model):
    """
    Модель, хранящая данные, относящиеся к сервису Takeout
    """
    parent = None

    extract_in_progress_since = UnixtimeField('takeout.extract_in_progress_since')

    archive_s3_key = Field('takeout.archive_s3_key')
    archive_password = Field('takeout.archive_password')
    archive_created_at = UnixtimeField('takeout.archive_created_at')
    fail_extract_at = UnixtimeField('takeout.fail_extract_at')
    subscription = BooleanField('takeout.subscription')
    delete_subscription = BooleanField('takeout.delete.subscription')
