PY23_LIBRARY()

OWNER(g:passport_python)

PEERDIR(
    contrib/python/six
    contrib/python/pytz

    passport/protobuf/plus_subscriber_state
    passport/backend/core/builders/blackbox
    passport/backend/core/conf
    passport/backend/core/crypto
    passport/backend/core/eav_type_mapping
    passport/backend/core/exceptions
    passport/backend/core/language_detect
    passport/backend/core/models/base
    passport/backend/core/models/domain
    passport/backend/core/models/phones
    passport/backend/core/password
    passport/backend/core/serializers/run_incr_phone_id
    passport/backend/core/services
    passport/backend/core/types
    passport/backend/core/types/account
    passport/backend/core/types/answer
    passport/backend/core/types/expirable_counter
    passport/backend/core/types/login
    passport/backend/core/types/phone_number
    passport/backend/core/types/question
    passport/backend/core/undefined
    passport/backend/utils
)

PY_SRCS(
    __init__.py
    account.py
    alias.py
    browser_key.py
    country.py
    delete_tasks.py
    device_public_key.py
    drive.py
    email.py
    family.py
    hint.py
    karma.py
    mailhost.py
    passman_recovery_key.py
    password.py
    persistent_track.py
    person.py
    plus.py
    rfc_totp_secret.py
    subscription.py
    support_code.py
    swap_domains_batch.py
    takeout.py
    totp_secret.py
    webauthn.py
    yakey_backup.py
)

END()

RECURSE(
    base
    domain
    faker
    phones
)

RECURSE_FOR_TESTS(
    tests
)
