# -*- coding: utf-8 -*-
from functools import partial

from passport.backend.core.models.base import Model
from passport.backend.core.models.base.fields import (
    Field,
    UnixtimeField,
)
from passport.backend.core.models.phones.phone import parse_phone_number_field


class YaKeyBackup(Model):
    phone_number = Field(partial(parse_phone_number_field, field_name='phone_number'))
    backup = Field('backup')
    updated = UnixtimeField('updated')
    device_name = Field('device_name')
