# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseProtobufError(BaseCoreError):
    pass


class RequiredFieldMissingValue(BaseProtobufError):
    """Не указано значение для обязательного поля"""


class UnknownVersionError(BaseProtobufError):
    pass


class CorruptDumpError(BaseProtobufError):
    """Ошибка парсинга protobuf дампа"""


class SerializationError(BaseProtobufError):
    """Не удалось сохранить объект в protobuf"""


__all__ = (
    'BaseProtobufError',
    'RequiredFieldMissingValue',
    'UnknownVersionError',
    'CorruptDumpError',
    'SerializationError',
)
