# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseS3Error(BaseCoreError):
    pass


class S3PermanentError(BaseS3Error):
    """Перманентная ошибка S3 - ретраиться бессмысленно"""


class FileNotFoundError(S3PermanentError):
    """Попытка прочитать файл по несуществующему ключу"""


class UnseekableStreamError(S3PermanentError):
    """Файловый объект не предоставил рабочий метод seek"""


class S3TemporaryError(BaseS3Error):
    """Временная ошибка S3, нужно поретраиться"""
