# -*- coding: utf-8 -*-

from passport.backend.core.exceptions import BaseCoreError


class EavError(BaseCoreError):
    pass


class EavValueError(EavError):
    pass


class EavDeletePDDAliasWithoutValueError(EavValueError):
    pass


class EavDeletedObjectNotFound(EavError):
    """Удаляемый объект не найден"""


class EavUpdatedObjectNotFound(EavError):
    """Изменяемый объект не найден"""
