# -*- coding: utf-8 -*-
from passport.backend.core.serializers.eav.base import (
    EavAttributeMap,
    EavSerializer,
)
from passport.backend.core.serializers.eav.processors import (
    default_processor,
    JoinProcessors,
)


@JoinProcessors([default_processor])
def hint_question_processor(question):
    return str(question)


class HintEavSerializer(EavSerializer):
    EAV_FIELDS_MAPPER = {
        # userinfo_safe.hintq.uid, если не null и непустое
        'question': EavAttributeMap('hint.question.serialized', hint_question_processor),
        'answer': EavAttributeMap('hint.answer.encrypted', default_processor),
    }

    def serialize(self, old, new, difference):
        if old is None:
            return self.create(new)
        elif new is None:
            return self.delete(old)
        else:
            return self.change(old, new, difference)

    def create(self, new):
        return self.build_change_fields_queries(
            self.EAV_FIELDS_MAPPER,
            new.parent.uid,
            None,
            new,
            self.EAV_FIELDS_MAPPER.keys(),
            True,
        )

    def change(self, old, new, difference):
        return self.build_change_fields_queries(
            self.EAV_FIELDS_MAPPER,
            new.parent.uid,
            old,
            new,
            difference.get_changed_fields(self.EAV_FIELDS_MAPPER.keys()),
        )

    def delete(self, old):
        return [
            self.build_delete_fields_query(
                self.EAV_FIELDS_MAPPER,
                old.parent.uid,
            ),
        ]
