# -*- coding: utf-8 -*-

from passport.backend.core.serializers.eav.base import EavSerializer
from passport.backend.core.serializers.eav.query import PassManInsertRecoveryKeyQuery


class PassManRecoveryKeySerializer(EavSerializer):

    def serialize(self, old, new, difference):
        old_key_id = old and old.key_id
        new_key_id = new and new.key_id
        if old_key_id or not new_key_id:
            raise ValueError('Can only create recovery key')

        return [
            PassManInsertRecoveryKeyQuery(
                uid=new.parent.uid,
                key_id=new_key_id,
                recovery_key=new.recovery_key,
            ),
        ]
