# -*- coding: utf-8 -*-

from passport.backend.core.serializers.eav.base import (
    EavAttributeMap,
    EavSerializer,
)
from passport.backend.core.serializers.eav.processors import (
    boolean_processor,
    datetime_processor,
    default_processor,
    plus_subscriber_state_processor,
)


class PlusEavSerializer(EavSerializer):
    EAV_FIELDS_MAPPER = {
        'enabled': EavAttributeMap('account.plus.enabled', boolean_processor),
        'trial_used_ts': EavAttributeMap('account.plus.trial_used_ts', datetime_processor),
        'subscription_stopped_ts': EavAttributeMap('account.plus.subscription_stopped_ts', datetime_processor),
        'subscription_expire_ts': EavAttributeMap('account.plus.subscription_expire_ts', datetime_processor),
        'next_charge_ts': EavAttributeMap('account.plus.next_charge_ts', datetime_processor),
        'ott_subscription': EavAttributeMap('account.plus.ott_subscription', default_processor),
        'family_role': EavAttributeMap('account.plus.family_role', default_processor),
        'cashback_enabled': EavAttributeMap('account.plus.cashback_enabled', boolean_processor),
        'subscription_level': EavAttributeMap('account.plus.subscription_level', default_processor),
        'is_frozen': EavAttributeMap('account.plus.is_frozen', boolean_processor),
        'subscriber_state': EavAttributeMap('account.plus.subscriber_state', plus_subscriber_state_processor),
    }

    def serialize(self, old, new, difference):
        queries = []
        if old and new is None:
            queries.extend(self.delete(old))
        else:
            queries.extend(self.change(old, new, difference))
        return queries

    def change(self, old, new, difference):
        return self.build_change_fields_queries(
            self.EAV_FIELDS_MAPPER,
            new.parent.uid,
            old,
            new,
            difference.get_changed_fields(),
            old is None,
        )

    def delete(self, plus):
        return [self.build_delete_fields_query(
            self.EAV_FIELDS_MAPPER,
            plus.parent.uid,
        )]
