# -*- coding: utf-8 -*-
from passport.backend.core.serializers.eav.base import (
    EavAttributeMap,
    EavSerializer,
)
from passport.backend.core.serializers.eav.processors import (
    default_processor,
    JoinProcessors,
)


@JoinProcessors([default_processor])
def rfc_totp_secret_processor(totp_secret):
    return totp_secret.serialized_secret


class RfcTotpSecretEavSerializer(EavSerializer):
    EAV_FIELDS_MAPPER = {
        'check_time': EavAttributeMap(
            'account.rfc_totp.check_time',
            default_processor,
        ),
        'totp_secret': EavAttributeMap(
            'account.rfc_totp.secret',
            rfc_totp_secret_processor,
        ),
    }

    def serialize(self, old, new, difference):
        queries = []
        if old and new is None:
            queries.extend(self.delete(old))
        else:
            queries.extend(self.change(old, new, difference))
        return queries

    def change(self, old, new, difference):
        serializable_fields = difference.get_changed_fields(self.EAV_FIELDS_MAPPER)
        return self.build_change_fields_queries(
            self.EAV_FIELDS_MAPPER,
            new.parent.uid,
            old,
            new,
            serializable_fields,
            old is None,
        )

    def delete(self, totp_secret):
        return [
            self.build_delete_fields_query(
                self.EAV_FIELDS_MAPPER,
                totp_secret.parent.uid,
            ),
        ]
