# -*- coding: utf-8 -*-
from passport.backend.core.db.query import DbTransaction
from passport.backend.core.dbmanager.manager import safe_execute_queries
from passport.backend.core.serializers.base import (
    serialize,
    serialize_attr,
    serialize_subscriptions,
)
from passport.backend.core.serializers.delete_tasks import PhoneBindingsHistoryDeleteTaskSerializer
from passport.backend.core.serializers.domain import DomainSerializer
from passport.backend.core.serializers.eav.alias import (
    AltDomainAliasEavSerializer,
    BankPhoneNumberAliasEavSerializer,
    FederalAliasEavSerializer,
    KiddishAliasEavSerializer,
    KinopoiskAliasEavSerializer,
    KolonkishAliasEavSerializer,
    LiteAliasEavSerializer,
    MailishAliasEavSerializer,
    NeophonishAliasEavSerializer,
    PddAliasEavSerializer,
    PhonenumberAliasEavSerializer,
    PhonishAliasEavSerializer,
    PortalAliasEavSerializer,
    PublicIdAliasEavSerializer,
    ScholarAliasEavSerializer,
    SocialAliasEavSerializer,
    UberAliasEavSerializer,
    YambotAliasEavSerializer,
    YandexoidAliasEavSerializer,
)
from passport.backend.core.serializers.eav.browser_key import BrowserKeyEavSerializer
from passport.backend.core.serializers.eav.completed_phonish_list import MigratedFromPhonishesSerializer
from passport.backend.core.serializers.eav.emails import (
    EmailEavSerializer,
    EmailsEavSerializer,
)
from passport.backend.core.serializers.eav.hint import HintEavSerializer
from passport.backend.core.serializers.eav.karma import KarmaEavSerializer
from passport.backend.core.serializers.eav.passman_recovery_key import PassManRecoveryKeySerializer
from passport.backend.core.serializers.eav.password import (
    PasswordEavSerializer,
    ScholarPasswordEavSerializer,
)
from passport.backend.core.serializers.eav.person import PersonEavSerializer
from passport.backend.core.serializers.eav.phones import (
    PhoneEavSerializer,
    serialize_phones,
)
from passport.backend.core.serializers.eav.plus import PlusEavSerializer
from passport.backend.core.serializers.eav.rfc_totp_secret import RfcTotpSecretEavSerializer
from passport.backend.core.serializers.eav.subscription import SubscriptionEavSerializer
from passport.backend.core.serializers.eav.takeout import TakeoutEavSerializer
from passport.backend.core.serializers.eav.totp_secret import (
    TotpSecretAutoIdEavSerializer,
    TotpSecretEavSerializer,
)
from passport.backend.core.serializers.eav.webauthn import WebauthnCredentialsEavSerializer
from passport.backend.core.serializers.eav.yakey_backup import YaKeyBackupSerializer
from passport.backend.core.serializers.family import FamilyInfoSerializer
from passport.backend.core.serializers.mailhost import MailhostSerializer
from passport.backend.core.serializers.persistent_track import PersistentTrackSerializer
from passport.backend.core.serializers.swap_domains_batch import SwapDomainsBatchSerializer


def _type_to_serializer():
    from passport.backend.core.serializers.eav import account

    return {
        'Account': account.AccountEavSerializer,
        'Domain': DomainSerializer,
        'Emails': EmailsEavSerializer,
        'Email': EmailEavSerializer,
        'FamilyInfo': FamilyInfoSerializer,
        'Hint': HintEavSerializer,
        'Karma': KarmaEavSerializer,
        'Password': PasswordEavSerializer,
        'Person': PersonEavSerializer,
        'Plus': PlusEavSerializer,
        'Takeout': TakeoutEavSerializer,
        'Subscription': SubscriptionEavSerializer,
        'Phone': PhoneEavSerializer,
        'PhoneBindingsHistoryDeleteTask': PhoneBindingsHistoryDeleteTaskSerializer,
        'PortalAlias': PortalAliasEavSerializer,
        'PddAlias': PddAliasEavSerializer,
        'LiteAlias': LiteAliasEavSerializer,
        'ScholarAlias': ScholarAliasEavSerializer,
        'SocialAlias': SocialAliasEavSerializer,
        'PhonishAlias': PhonishAliasEavSerializer,
        'NeophonishAlias': NeophonishAliasEavSerializer,
        'MailishAlias': MailishAliasEavSerializer,
        'KiddishAlias': KiddishAliasEavSerializer,
        'KinopoiskAlias': KinopoiskAliasEavSerializer,
        'KolonkishAlias': KolonkishAliasEavSerializer,
        'PublicIdAlias': PublicIdAliasEavSerializer,
        'PhonenumberAlias': PhonenumberAliasEavSerializer,
        'AltDomainAlias': AltDomainAliasEavSerializer,
        'BankPhoneNumberAlias': BankPhoneNumberAliasEavSerializer,
        'FederalAlias': FederalAliasEavSerializer,
        'YandexoidAlias': YandexoidAliasEavSerializer,
        'UberAlias': UberAliasEavSerializer,
        'YambotAlias': YambotAliasEavSerializer,
        'RfcTotpSecret': RfcTotpSecretEavSerializer,
        'TotpSecret': TotpSecretEavSerializer,
        'TotpSecretAutoId': TotpSecretAutoIdEavSerializer,
        'BrowserKey': BrowserKeyEavSerializer,
        'MailHost': MailhostSerializer,
        'PersistentTrack': PersistentTrackSerializer,
        'CompletedPhonishList': MigratedFromPhonishesSerializer,
        'YaKeyBackup': YaKeyBackupSerializer,
        'SwapDomainsBatch': SwapDomainsBatchSerializer,
        'PassManRecoveryKey': PassManRecoveryKeySerializer,
        'WebauthnCredentials': WebauthnCredentialsEavSerializer,
        'ScholarPassword': ScholarPasswordEavSerializer,
    }


def serialize_eav(old_snapshot, new_snapshot, difference=None):
    return serialize(old_snapshot, new_snapshot, difference, _type_to_serializer())


def serialize_eav_attr(old_snapshot, new_snapshot, difference, attr):
    return serialize_attr(old_snapshot, new_snapshot, difference, attr, serialize_eav)


def serialize_eav_subscriptions(old, new, difference):
    return serialize_subscriptions(old, new, difference, serialize_eav)


@DbTransaction
def serialize_eav_phones(old, new, difference):
    return serialize_phones(old, new, difference)


def serialize_eav_account_deletion_operation(old, new, difference):
    from passport.backend.core.serializers.eav import account
    return account.AccountDeletionOperationSerializer().serialize(old, new, difference)


def serialize_snapshots(old_snapshot, new_snapshot, diff=None, retries=None, transaction_retries=None,
                        with_low_timeout=False):
    queries = serialize_eav(old_snapshot, new_snapshot, diff)
    safe_execute_queries(
        queries,
        retries=retries,
        transaction_retries=transaction_retries,
        with_low_timeout=with_low_timeout,
    )
