# -*- coding: utf-8 -*-
from .base import (
    EavAttributeMap,
    EavSerializer,
)
from .processors import (
    datetime_processor,
    default_processor,
    unary_field_processor,
)


class TakeoutEavSerializer(EavSerializer):
    EAV_FIELDS_MAPPER = {
        'extract_in_progress_since': EavAttributeMap(
            'takeout.extract_in_progress_since',
            datetime_processor,
        ),
        'archive_s3_key': EavAttributeMap(
            'takeout.archive_s3_key',
            default_processor,
        ),
        'archive_password': EavAttributeMap(
            'takeout.archive_password',
            default_processor,
        ),
        'archive_created_at': EavAttributeMap(
            'takeout.archive_created_at',
            datetime_processor,
        ),
        'fail_extract_at': EavAttributeMap(
            'takeout.fail_extract_at',
            datetime_processor,
        ),
        'subscription': EavAttributeMap(
            'takeout.subscription',
            unary_field_processor,
        ),
        'delete_subscription': EavAttributeMap(
            'takeout.delete.subscription',
            unary_field_processor,
        ),
    }

    def serialize(self, old, new, difference):
        queries = []
        if old and new is None:
            queries.extend(self.delete(old))
        else:
            queries.extend(self.change(old, new, difference))
        return queries

    def change(self, old, new, difference):
        serializable_fields = difference.get_changed_fields(self.EAV_FIELDS_MAPPER)
        return self.build_change_fields_queries(
            self.EAV_FIELDS_MAPPER,
            new.parent.uid,
            old,
            new,
            serializable_fields,
            old is None,
        )

    def delete(self, takeout):
        return [
            self.build_delete_fields_query(
                self.EAV_FIELDS_MAPPER,
                takeout.parent.uid,
            ),
        ]
