# -*- coding: utf-8 -*-
from passport.backend.core.differ.types import EmptyDiff
from passport.backend.core.serializers.eav.base import EavSerializer
from passport.backend.core.serializers.eav.query import (
    YaKeyBackupCreateQuery,
    YaKeyBackupDeleteQuery,
    YaKeyBackupUpdateQuery,
)
from passport.backend.utils.string import smart_bytes


class YaKeyBackupSerializer(EavSerializer):

    def serialize(self, old, new, difference):
        if not new and old:
            return [
                YaKeyBackupDeleteQuery(
                    int(old.phone_number.digital),
                ),
            ]

        if old and old.phone_number != new.phone_number:
            raise ValueError('YaKey Backup can not update phone number')

        if difference == EmptyDiff:
            return []

        if old and old.updated:
            return [
                YaKeyBackupUpdateQuery(
                    int(new.phone_number.digital),
                    smart_bytes(new.backup),
                    new.updated,
                    old.updated,
                    new.device_name,
                ),
            ]

        return [
            YaKeyBackupCreateQuery(
                int(new.phone_number.digital),
                smart_bytes(new.backup),
                new.updated,
                new.device_name,
            ),
        ]
