# -*- coding: utf-8 -*-
from base64 import b64encode
import json

from passport.backend.core.models.account import ACCOUNT_ENABLED
from passport.backend.core.models.email import Email
from passport.backend.core.types.login.login import normalize_login
from passport.backend.utils.string import smart_text
from passport.backend.utils.time import (
    datetime_to_string,
    datetime_to_unixtime,
)
import six


def default_formatter(value):
    return six.text_type(value) if value is not None else None


def punycode_formatter(value):
    return value.encode('idna').decode('utf8') if value is not None else None


def boolean_formatter(value):
    return str(int(value))


def disabled_to_ena_formatter(value):
    if value == ACCOUNT_ENABLED:
        return '1'
    else:
        return '0'


def datetime_to_timestamp_formatter(value):
    return str(int(datetime_to_unixtime(value)))


def datetime_formatter(value):
    return datetime_to_string(value)


def empty_to_null_formatter(value):
    return value if value else None


def login_formatter(value):
    return normalize_login(value)


def mailish_login_formatter(value):
    return value.lower() if value else None


def sid_formatter(value_list):
    return u'|'.join([smart_text(attr) for attr in value_list])


def phone_e164_formatter(value):
    return value.e164 if value else None


def normalized_email_formatter(raw):
    return Email.normalize_address(raw, encode_domain=False)


def mail_formatter(value_list):
    return ','.join([str(attr) for attr in value_list])


def collection_formatter(value_list):
    return ','.join([str(item) for item in sorted(value_list)]) if value_list else None


def base64_formatter(value):
    return b64encode(value).decode('utf8') if value else None


def constant_response_formatter(response_value):
    def formatter(value):
        return response_value
    return formatter


def json_formatter(value, one_line=True):
    if not value:
        return
    formatted = json.dumps(value, sort_keys=True)
    if one_line:
        formatted = formatted.replace('\n', ' ')
    return formatted


zero_response_formatter = constant_response_formatter('0')


def null_formatter(value):
    return None
