# -*- coding: utf-8 -*-


def identical_getter(snapshot, diff, value):
    return value


def login_getter(snapshot, diff, value):
    return value.login if value else None


def altdomain_alias_getter(snapshot, diff, value):
    return snapshot.altdomain_alias.serialized_alias if value else None


def pdd_alias_getter(snapshot, diff, value):
    return snapshot.pdd_alias.serialized_alias if value else None


def number_getter(snapshot, diff, value):
    return value.number if value else None


def sid_add_getter(snapshot, diff, value):
    sid = value.sid
    login = value.login
    if login:
        return sid, login
    return sid,


def sid_rm_getter(snapshot, diff, value):
    sid = value.sid
    login = value.login or snapshot.login
    if login:
        return sid, login
    return sid,


def sid_info_getter(snapshot, diff, value):
    sub = snapshot.subscriptions[value.sid]
    return sub.parent.uid, sub.login or snapshot.login, sub.suid


def sid_login_rule_getter(snapshot, diff, value):
    sid = value.sid
    login_rule = diff.changed['subscriptions'][sid]['login_rule']
    return sid, login_rule


def mail_sid_info_getter(snapshot, diff, value):
    sub = snapshot.subscriptions[value.sid]
    return sub.suid,
