# -*- coding: utf-8 -*-

from passport.backend.core.serializers.logs.historydb.rules.base import HistoryDBSerializerRule
from passport.backend.core.serializers.logs.utils import hierarchical_get


class HistoryDBPddAliasLoginsSerializerRule(HistoryDBSerializerRule):
    def make_entries(self, old_snapshot, new_snapshot, diff):
        old_logins = hierarchical_get(old_snapshot, self.entity) or set()
        new_logins = hierarchical_get(new_snapshot, self.entity) or set()

        added_logins = new_logins - old_logins
        removed_logins = old_logins - new_logins
        entries = []
        domain = old_snapshot.domain if old_snapshot else new_snapshot.domain

        for entity_alias, logins in (
            ('alias.pddalias.add', sorted(added_logins)),
            ('alias.pddalias.rm', sorted(removed_logins)),
        ):
            if logins:
                emails = ','.join([
                    '%s@%s' % (login, self.value_formatter(domain.domain))
                    for login in logins
                ])
                entries.append((entity_alias, emails))
        return entries

    def is_applicable(self, old_snapshot, new_snapshot, diff):
        """Пишем событие об удалении только при наличии изменений в списке логинов"""
        old_logins = hierarchical_get(old_snapshot, self.entity) or set()
        new_logins = hierarchical_get(new_snapshot, self.entity) or set()
        return old_logins != new_logins


class HistoryDBOldPublicIdsSerializerRule(HistoryDBSerializerRule):
    def make_entries(self, old_snapshot, new_snapshot, diff):
        old_logins = hierarchical_get(old_snapshot, self.entity) or set()
        new_logins = hierarchical_get(new_snapshot, self.entity) or set()

        added_logins = new_logins - old_logins
        removed_logins = old_logins - new_logins
        entries = []

        for entity_alias, logins in (
            ('alias.old_public_id.add', sorted(added_logins)),
            ('alias.old_public_id.rm', sorted(removed_logins)),
        ):
            if logins:
                entries.append((entity_alias, ','.join(logins)))
        return entries

    def is_applicable(self, old_snapshot, new_snapshot, diff):
        """Пишем событие об удалении только при наличии изменений в списке логинов"""
        old_logins = hierarchical_get(old_snapshot, self.entity) or set()
        new_logins = hierarchical_get(new_snapshot, self.entity) or set()
        return old_logins != new_logins
