# -*- coding: utf-8 -*-

from passport.backend.core.serializers.logs.base import (
    CHANGED,
    DELETED,
)
from passport.backend.core.serializers.logs.historydb.rules.base import HistoryDBSerializerRule


class HistoryDBFamilyKidDeleteRule(HistoryDBSerializerRule):
    """
    Срабатывает, когда
        * Удаляется ребёнкиш с семьей (т.е. известен account.family_info.family_id)

    Производит
        * Запись об удалении ребёнкиша из семьи
    """
    def __init__(self):
        super(HistoryDBFamilyKidDeleteRule, self).__init__(
            entity=None,
            operations=(DELETED,),
            entity_alias='family.%s.family_kid',
        )

    def is_applicable(self, old_snapshot, new_snapshot, diff):
        if (
            old_snapshot and
            old_snapshot.family_info and
            old_snapshot.family_info.family_id and
            not new_snapshot
        ):
            return old_snapshot.is_kiddish
        else:
            return False

    def make_entries(self, old_snapshot, new_snapshot, diff, **kwargs):
        entity = self.entity_alias % old_snapshot.family_info.family_id
        return [(entity, None)]


class HistoryDBFamilyChildDeleteRule(HistoryDBSerializerRule):
    """
    Срабатывает, когда
        * Ребёнок с семьей ставится на удаление-карантин (т.е. известен account.family_info.family_id)

    Производит
        * Запись об удалении ребёнкиша из семьи
    """
    def __init__(self):
        super(HistoryDBFamilyChildDeleteRule, self).__init__(
            entity=None,
            operations=(CHANGED,),
            entity_alias='family.%s.family_child',
        )

    def is_applicable(self, old_snapshot, new_snapshot, diff):
        if (
            old_snapshot and
            old_snapshot.family_info and
            old_snapshot.family_info.family_id and
            not new_snapshot
        ):
            return old_snapshot.is_child
        else:
            return False

    def make_entries(self, old_snapshot, new_snapshot, diff, **kwargs):
        entity = self.entity_alias % old_snapshot.family_info.family_id
        return [(entity, None)]
