# -*- coding: utf-8 -*-
from passport.backend.core.serializers.logs.base import (
    ADDED,
    CHANGED,
    DELETED,
)
from passport.backend.core.serializers.logs.historydb.rules.base import HistoryDBSerializerRule
from passport.backend.core.serializers.logs.utils import hierarchical_exists


class BaseHistoryDBHintSerializerRule(HistoryDBSerializerRule):
    ENTITY_ALIAS_TO_FIELD = [('info.hintq', 'question'), ('info.hinta', 'answer')]

    def make_entity(self, field):
        raise NotImplementedError()  # pragma: no cover

    def is_applicable(self, old_snapshot, new_snapshot, diff):
        """Применимо ли правило к данному диффу"""
        for _, field in self.ENTITY_ALIAS_TO_FIELD:
            applicable = any(
                hierarchical_exists(diff, '%s.%s' % (operation, self.make_entity(field)))
                for operation in self.allowed_operations
            )
            if applicable:
                return True
        return False

    def make_entries(self, old_snapshot, new_snapshot, diff):
        entries = []
        for entity_alias, field in self.ENTITY_ALIAS_TO_FIELD:
            formatted_value = self._get_formatted_value(
                old_snapshot,
                new_snapshot,
                diff,
                args=[field],
            )
            entries.append((entity_alias, formatted_value))

        return entries


class HistoryDBHintSetSerializerRule(BaseHistoryDBHintSerializerRule):
    def __init__(self):
        super(HistoryDBHintSetSerializerRule, self).__init__(
            operations=(ADDED, CHANGED),
        )

    def make_entity(self, field):
        return '.'.join([self.entity, field])


class HistoryDBHintDeleteSerializerRule(BaseHistoryDBHintSerializerRule):
    def __init__(self):
        super(HistoryDBHintDeleteSerializerRule, self).__init__(
            operations=(DELETED,),
        )

    def make_entity(self, field):
        return self.entity
