# -*- coding: utf-8 -*-
from passport.backend.core.serializers.logs.historydb.rules.base import HistoryDBSerializerRule
from passport.backend.core.serializers.logs.utils import hierarchical_get


class HistoryDBKarmaSerializerRule(HistoryDBSerializerRule):
    """Базовое правило сериализации
    и изменений кармы для HistoryDB"""

    def _get_full_value(self, old_snapshot, new_snapshot, diff):
        new_prefix_value = hierarchical_get(new_snapshot, 'karma.prefix')
        new_suffix_value = hierarchical_get(new_snapshot, 'karma.suffix')

        new_value = '%s%03d' % (new_prefix_value, new_suffix_value) if new_prefix_value else new_suffix_value

        return new_value

    def _get_formatted_full_value(self, old_snapshot, new_snapshot, diff):
        new_value = self._get_full_value(old_snapshot, new_snapshot, diff)
        return self.value_formatter(new_value)

    def make_entries(self, old_snapshot, new_snapshot, diff):
        """Возвращает список лог-записей, созданных этим правилом"""
        formatted_value = self._get_formatted_value(old_snapshot, new_snapshot, diff)
        formatted_full_value = self._get_formatted_full_value(old_snapshot, new_snapshot, diff)
        return [
            (self.entity_alias, formatted_value),
            ('info.karma_full', formatted_full_value)
        ]
