# -*- coding: utf-8 -*-
from passport.backend.core.serializers.logs.historydb.rules.base import HistoryDBSerializerRule
from passport.backend.core.types.login.login import normalize_login


class HistoryDBLoginSerializerRule(HistoryDBSerializerRule):
    def make_entries(self, old_snapshot, new_snapshot, diff):
        snapshot = new_snapshot or old_snapshot
        if not snapshot.login:
            return []
        entries = [
            ('info.login', self.value_formatter(normalize_login(snapshot.login))),
        ]
        if (
            snapshot.user_defined_login and
            snapshot.user_defined_login != snapshot.normalized_login
        ):
            entries.append(
                ('info.login_wanted', self.value_formatter(snapshot.user_defined_login)),
            )

        return entries

    def is_applicable(self, old_snapshot, new_snapshot, diff):
        return (
            old_snapshot is None or
            new_snapshot is None or
            new_snapshot.login != old_snapshot.login
        )
