# -*- coding: utf-8 -*-

from passport.backend.core.serializers.logs.historydb.rules.base import HistoryDBSerializerRule


class HistoryDBPhoneSerializerRule(HistoryDBSerializerRule):
    """Формирует записи в формате phone.<phone_id>.key = value"""

    def make_entries(self, old_snapshot, new_snapshot, diff, phone_id):
        """Возвращает список лог-записей, созданных этим правилом"""
        formatted_value = self._get_formatted_value(old_snapshot, new_snapshot, diff)
        return [('phone.%s.%s' % (phone_id, self.entity_alias), formatted_value)]


class HistoryDBPhoneOperationSerializerRule(HistoryDBSerializerRule):
    """Формирует записи в формате phone.<phone_id>.key = value"""

    def __init__(self, *args, **kwargs):
        super(HistoryDBPhoneOperationSerializerRule, self).__init__(*args, **kwargs)

        if self._entity_alias is None:
            # Смысл в том, что при применении правила к entity слева добавится "operation.",
            # что сломает формирование имени в make_entries (будет operation.id.operation.key).
            # А _entity_alias не изменяется.
            self._entity_alias = self.entity

    def make_entries(self, old_snapshot, new_snapshot, diff, phone_id, operation_id):
        """Возвращает список лог-записей, созданных этим правилом"""
        formatted_value = self._get_formatted_value(old_snapshot, new_snapshot, diff)
        return [('phone.%s.operation.%s.%s' % (phone_id, operation_id, self.entity_alias), formatted_value)]


def get_action(old, new):
    if not new:
        return 'deleted'
    elif not old:
        return 'created'
    return 'changed'


class HistoryDBPhoneActionSerializerRule(HistoryDBPhoneSerializerRule):
    def _get_formatted_value(self, old_snapshot, new_snapshot, diff, args=None):
        return get_action(old_snapshot, new_snapshot)


class HistoryDBPhoneOperationActionSerializerRule(HistoryDBPhoneOperationSerializerRule):
    def _get_formatted_value(self, old_snapshot, new_snapshot, diff, args=None):
        return get_action(
            old_snapshot.operation if old_snapshot else None,
            new_snapshot.operation if new_snapshot else None,
        )
