# -*- coding: utf-8 -*-
from passport.backend.core.serializers.logs.base import DELETED
from passport.backend.core.serializers.logs.historydb.rules.base import HistoryDBSerializerRule
from passport.backend.core.serializers.logs.utils import hierarchical_get


class HistoryDBPlusDeleteSerializerRule(HistoryDBSerializerRule):
    def __init__(self, entity=''):
        super(HistoryDBPlusDeleteSerializerRule, self).__init__(
            entity=entity,
            operations=(DELETED,),
        )

    def make_entries(self, old_snapshot, new_snapshot, diff):
        entities = [
            'plus.enabled',
            'plus.trial_used_ts',
            'plus.subscription_stopped_ts',
            'plus.subscription_expire_ts',
            'plus.next_charge_ts',
            'plus.ott_subscription',
            'plus.family_role',
            'plus.cashback_enabled',
            'plus.subscription_level',
            'plus.is_frozen',
            'plus.subscriber_state',
        ]

        retval = []
        for entity in entities:
            old_value = hierarchical_get(old_snapshot, entity)
            if old_value is None:
                continue

            if entity not in diff.deleted and diff.deleted.get('plus'):
                continue

            retval.append((entity, self.value_formatter_for_deleted(hierarchical_get(new_snapshot, entity))))
        return retval
