# -*- coding: utf-8 -*-
from passport.backend.core.serializers.logs.base import DELETED
from passport.backend.core.serializers.logs.historydb.rules.base import HistoryDBSerializerRule
from passport.backend.core.serializers.logs.utils import hierarchical_get


class HistoryDBTotpSecretIdsSerializerRule(HistoryDBSerializerRule):
    def __init__(self, entity='secret_ids', entity_alias='info.totp_secret.%d'):
        super(HistoryDBTotpSecretIdsSerializerRule, self).__init__(
            entity=entity,
            entity_alias=entity_alias,
        )

    def make_entries(self, old_snapshot, new_snapshot, diff):
        old_value = hierarchical_get(old_snapshot, self.entity) or {}
        new_value = hierarchical_get(new_snapshot, self.entity) or {}
        old_secret_ids = set(old_value.keys())
        new_secret_ids = set(new_value.keys())

        entries = []
        if not old_secret_ids and new_secret_ids:
            entries.append(('info.totp', 'enabled'))
        for added_secret_id in new_secret_ids - old_secret_ids:
            entries.append((self.entity_alias % added_secret_id, '*'))
        for deleted_secret_id in old_secret_ids - new_secret_ids:
            entries.append((self.entity_alias % deleted_secret_id, None))

        return entries


class HistoryDBTotpSecretDeleteSerializerRule(HistoryDBSerializerRule):
    def __init__(self, entity=''):
        super(HistoryDBTotpSecretDeleteSerializerRule, self).__init__(
            entity=entity,
            operations=(DELETED,),
        )

    def make_entries(self, old_snapshot, new_snapshot, diff):
        old_value = hierarchical_get(old_snapshot, self.entity)
        new_value = hierarchical_get(new_snapshot, self.entity)

        entries = []
        if not new_value:
            entries.append(('info.totp', 'disabled'))
            entries.append(('info.totp_update_time', None))
            for deleted_secret_id in old_value.secret_ids or {}:
                entries.append(('info.totp_secret.%d' % deleted_secret_id, None))

        return entries
