# -*- coding: utf-8 -*-
from passport.backend.core.models.account import (
    ACCOUNT_DISABLED,
    ACCOUNT_DISABLED_ON_DELETION,
    ACCOUNT_ENABLED,
    MAIL_STATUS_ACTIVE,
    MAIL_STATUS_FROZEN,
    MAIL_STATUS_NONE,
)
from passport.backend.core.serializers.logs.utils import NULL
from passport.backend.core.types.gender import Gender
from passport.backend.utils.time import datetime_to_unixtime


def default_formatter(value):
    return value if value is not None else NULL


def shadowed_formatter(value):
    return


def gender_formatter(value):
    mapped = Gender.to_char(value)
    return mapped if mapped is not None else NULL


def format_phone_number(value, should_mask=True):
    if value is not None:
        if should_mask:
            value = value.masked_format_for_statbox
        else:
            value = value.e164
    else:
        value = NULL
    return value


def optional_datetime_formatter(value):
    if not value:
        return '-'
    unixtime = int(datetime_to_unixtime(value))
    if not unixtime:
        return '-'
    return value


def disabled_status_formatter(value):
    if value == ACCOUNT_ENABLED:
        return 'enabled'
    elif not value:
        return '-'
    elif value == ACCOUNT_DISABLED:
        return 'disabled'
    elif value == ACCOUNT_DISABLED_ON_DELETION:
        return 'disabled_on_deletion'


def mail_status_formatter(value):
    if not value or value == MAIL_STATUS_NONE:
        return '-'
    elif value == MAIL_STATUS_ACTIVE:
        return 'active'
    elif value == MAIL_STATUS_FROZEN:
        return 'frozen'
