# -*- coding: utf-8 -*-

from passport.backend.core.serializers.logs.base import DELETED
from passport.backend.core.serializers.logs.statbox.rules.base import StatboxSerializerRule


class StatboxFamilyKidDeleteRule(StatboxSerializerRule):
    """
    Срабатывает, когда
        * Удаляется ребёнкиш с семьей (т.е. известен account.family_info.family_id)

    Производит
        * Запись о удалении ребёнкиша из семьи
    """
    def __init__(self):
        super(StatboxFamilyKidDeleteRule, self).__init__(
            entity=None,
            entity_alias='kid',
            event='family_info_modification',
            operations=(DELETED,),
        )

    def is_applicable(self, old_snapshot, new_snapshot, diff):
        if (
            old_snapshot and
            old_snapshot.family_info and
            old_snapshot.family_info.family_id and
            not new_snapshot
        ):
            return old_snapshot.is_kiddish
        else:
            return False

    def make_entries(self, old_snapshot, new_snapshot, diff, **kwargs):
        return [
            dict(
                attribute='uid',
                entity=self.entity_alias,
                entity_id=str(old_snapshot.uid),
                event=self.event,
                family_id=str(old_snapshot.family_info.family_id),
                new='-',
                old=str(old_snapshot.uid),
                operation='deleted',
            ),
        ]
