# -*- coding: utf-8 -*-

from passport.backend.core.serializers.logs.statbox.getters import value_getter
from passport.backend.core.serializers.logs.statbox.rules.base import StatboxSerializerRule


class StatboxKarmaSerializerRule(StatboxSerializerRule):
    """Правило сериализации изменений кармы для Statbox (для ФО)"""
    def __init__(self, entity=''):
        super(StatboxKarmaSerializerRule, self).__init__(
            entity=entity,
            getter=value_getter,
            snapshot_fields={
                'registration_datetime': 'registration_datetime',
                'login': 'normalized_login',
                'suid': 'subscriptions.2.suid',
            },
            extra_fields={
                'destination': 'frodo',
            },
        )

    def _base_entry(self, action, operation):
        return {
            'event': self.event,
            'action': action,
            'entity': 'karma',
        }

    def _get_fields_from_snapshot(self, old_snapshot, new_snapshot):
        """
        Специальная обработка (костыль) случая, когда нам нужно записать
        логин ПДДшника. Для обычных пользователей везде ожидается
        нормализованный логин, но мы не можем отдавать human_readable_login,
        т.к. для них это свойство просто отдаст ненормализованный логин из
        8-го сида. Поэтому для ПДДшников подменяем выдаваемый логин
        """
        result = super(StatboxKarmaSerializerRule, self)._get_fields_from_snapshot(
            old_snapshot,
            new_snapshot,
        )

        for field in ['is_federal', 'is_pdd']:
            if self._get_field_from_snapshot(
                field,
                old_snapshot,
                new_snapshot,
            ) is True:
                result['login'] = self._get_field_from_snapshot(
                    'human_readable_login',
                    old_snapshot,
                    new_snapshot,
                )
                break
        return result
