# -*- coding: utf-8 -*-

from passport.backend.core.serializers.logs.base import (
    ADDED,
    DELETED,
)
from passport.backend.core.serializers.logs.statbox.rules.base import StatboxAttributeOfListItemSerializerRule


class StatboxSubscriptionSerializerRule(StatboxAttributeOfListItemSerializerRule):
    operation_mapping = {
        'created': 'added',
        'updated': 'updated',
        'deleted': 'removed',
    }

    def __init__(self):
        super(StatboxSubscriptionSerializerRule, self).__init__(
            '',
            operations=(ADDED, DELETED),
        )

    def make_entries(self, old_snapshot, new_snapshot, diff, action,
                     entity_alias, entity_id):
        operation, old, new = self._get_operation_and_values(old_snapshot, new_snapshot)
        operation = self.operation_mapping[operation]

        kwargs = {}
        if int(entity_id) == 2:
            kwargs['suid'] = self._get_field_from_snapshot(
                'subscriptions.2.suid',
                old_snapshot,
                new_snapshot,
            )

        return [
            self._make_entry(
                old_snapshot,
                new_snapshot,
                diff,
                action,
                operation,
                entity='subscriptions',
                sid=entity_id,
                **kwargs
            ),
        ]

    def _base_entry(self, action, operation):
        return {
            'event': self.event,
            'operation': operation,
        }
