# -*- coding: utf-8 -*-

from passport.backend.core.logging_utils.loggers import (
    CryptastatLogger,
    PharmaLogger,
    StatboxLogger,
)
from passport.backend.core.logging_utils.loggers.family import FamilyLogger
from passport.backend.core.logging_utils.loggers.statbox import (
    AccountModificationInfosecLogger,
    AccountModificationLogger,
)
from passport.backend.core.serializers.logs.statbox.formatters import NULL
from passport.backend.core.serializers.logs.statbox.serializers import (
    CryptastatPhonesSerializer,
    PharmaPhonesSerializer,
    StatboxAccountInfosecSerializer,
    StatboxAccountSerializer,
    StatboxFamilySerializer,
    StatboxPddDomainSerializer,
)
from passport.backend.core.serializers.runner import BaseSerializeActionRunner


class StatboxActionRunner(BaseSerializeActionRunner):
    logger_cls = StatboxLogger
    serializer_cls = StatboxAccountSerializer

    def __init__(self, events, user_ip, user_agent, uid):
        self.logger = self.logger_cls(
            uid=uid,
            consumer=events.get('consumer', NULL),
            ip=user_ip,
            user_agent=user_agent or NULL,
        )

    def _execute(self, entry):
        self.logger.log(**entry)

    def serialize(self, old_snapshot, new_snapshot, diff=None, action=None):
        return self.serializer_cls().serialize(old_snapshot, new_snapshot, diff, action=action)


class StatboxAccountRunner(StatboxActionRunner):
    serializer_cls = StatboxAccountSerializer


class StatboxDomainRunner(BaseSerializeActionRunner):
    logger_cls = StatboxLogger
    serializer_cls = StatboxPddDomainSerializer

    def __init__(self, events, user_ip, user_agent, domain_id):
        self.logger = self.logger_cls(
            domain_id=domain_id,
            consumer=events.get('consumer', NULL),
            ip=user_ip,
            user_agent=user_agent or NULL,
        )

    def _execute(self, entry):
        self.logger.log(**entry)

    def serialize(self, old_snapshot, new_snapshot, diff=None, action=None):
        return self.serializer_cls().serialize(
            old_snapshot,
            new_snapshot,
            diff,
            action=action,
            event='domain_modification',
        )


class CryptastatActionRunner(StatboxActionRunner):
    logger_cls = CryptastatLogger
    serializer_cls = CryptastatPhonesSerializer


class StatboxFamilyRunner(StatboxActionRunner):
    logger_cls = FamilyLogger
    serializer_cls = StatboxFamilySerializer

    def __init__(self, events, user_ip, user_agent, family_id):
        self.logger = self.logger_cls(
            family_id=family_id,
            consumer=events.get('consumer', NULL),
            ip=user_ip,
            user_agent=user_agent or NULL,
        )
        self.basic_logger = StatboxLogger(
            family_id=family_id,
            consumer=events.get('consumer', NULL),
            ip=user_ip,
            user_agent=user_agent or NULL,
        )

    def _execute(self, entry):
        self.logger.log(**entry)
        self.basic_logger.log(**entry)

    def serialize(self, old_snapshot, new_snapshot, diff=None, action=None):
        return self.serializer_cls().serialize(
            old_snapshot,
            new_snapshot,
            diff,
            action=action,
            event='family_info_modification',
        )


class PharmaActionRunner(StatboxActionRunner):
    def __init__(self, events, user_ip, user_agent, uid):
        self.logger = self.logger_cls(
            uid=uid,
            user_ip=user_ip,
            user_agent=user_agent or NULL,
        )

    logger_cls = PharmaLogger
    serializer_cls = PharmaPhonesSerializer


class AccountModificationRunner(StatboxAccountRunner):
    logger_cls = AccountModificationLogger

    def __init__(self, events, user_ip, user_agent, uid=None, domain_id=None, family_id=None):
        self.logger = self.logger_cls(
            uid=uid,
            consumer=events.get('consumer', NULL),
            ip=user_ip,
            user_agent=user_agent or NULL,
        )


class AccountModificationInfosecRunner(StatboxActionRunner):
    def __init__(self, events, user_ip, user_agent, uid=None, domain_id=None, family_id=None):
        self.logger = AccountModificationInfosecLogger(
            uid=uid,
            consumer=events.get('consumer', NULL),
            ip=user_ip,
            user_agent=user_agent or NULL,
        )

    def _execute(self, entry):
        self.logger.log(**entry)

    def serialize(self, old_snapshot, new_snapshot, diff=None, action=None):
        return StatboxAccountInfosecSerializer().serialize(old_snapshot, new_snapshot, diff, action=action)
