# -*- coding: utf-8 -*-
from passport.backend.core.models.base import Model
from passport.backend.core.undefined import Undefined
from passport.backend.utils.string import smart_unicode


NULL = '-'


def _hierarchical_get(object_, path):
    current_level = object_
    for field in path.split('.'):
        if isinstance(current_level, dict):
            if field in current_level:
                current_level = current_level[field]
            elif field.isdigit() and int(field) in current_level:
                current_level = current_level[int(field)]
            else:
                return False, None
        else:
            if current_level in (Undefined, None):
                return False, None
            current_level = getattr(current_level, field)
    if current_level is Undefined:
        return True, None
    return True, current_level


def hierarchical_get(object_, path):
    """
    Достаёт вложенное значение из объекта по указанному пути.
    Может проходить по полям и свойствам объектов и по ключам (строковым или числовым) словарей.
    """
    _, value = _hierarchical_get(object_, path)
    return value


def hierarchical_exists(object_, path):
    """
    Проверяет, существует ли в объекте значение по указанному пути.
    Может проходить по полям и свойствам объектов и по ключам (строковым или числовым) словарей.
    """
    found, _ = _hierarchical_get(object_, path)
    return found


def join_str(first, second, delimiter='.'):
    """
    Если first и second оба непусты - возвращает их записанными через delimiter.
    Иначе возвращает то из значений, которое не пусто.
    """
    if not first:
        return second or ''
    elif not second:
        return first or ''
    else:
        return '%s%s%s' % (first, delimiter, second)


def is_not_empty(value):
    if isinstance(value, Model) and value.is_empty():
        return False

    return value is not None and smart_unicode(value, errors='replace') != u''
