# -*- coding: utf-8 -*-

from passport.backend.core.db.runner import get_id_from_query_result
from passport.backend.core.db.schemas import (
    domains_hosts_table,
    hosts_table,
)
from passport.backend.core.models.mailhost import MailHost
from passport.backend.core.serializers.base import DirectSerializer
from passport.backend.core.serializers.query import (
    GenericDeleteQuery,
    GenericInsertQuery,
    GenericUpdateQuery,
)


class MailhostSerializer(DirectSerializer):
    model = MailHost
    table = hosts_table
    pdd_table = domains_hosts_table

    field_mapping = {
        'id': 'host_id',
        'priority': 'prio',
        'mx': 'mx',
        'db_id': 'db_id',
        'sid': 'sid',
        'number': 'host_number',
        'name': 'host_name',
        'ip': 'host_ip',
    }

    def create(self, old, new, data):
        yield (
            GenericInsertQuery(self.table, data),
            lambda result: setattr(new, 'id', get_id_from_query_result(result)),
        )
        data['host_id'] = new.id
        yield (GenericInsertQuery(self.pdd_table, data), None)

    def change(self, old, new, data):
        db_id = old.db_id
        return [
            GenericUpdateQuery(self.table, None, data, filter_by=(self.table.c.db_id == db_id.encode('utf8'))),
            GenericUpdateQuery(self.pdd_table, None, data, filter_by=(self.pdd_table.c.db_id == db_id.encode('utf8'))),
        ]

    def delete(self, old):
        db_id = old.db_id
        return [
            GenericDeleteQuery(self.table, None, filter_by=(self.table.c.db_id == db_id.encode('utf8'))),
            GenericDeleteQuery(self.pdd_table, None, filter_by=(self.pdd_table.c.db_id == db_id.encode('utf8'))),
        ]
