# -*- coding: utf-8 -*-
from passport.backend.core.dbmanager.manager import safe_execute_queries
from passport.backend.core.runner import BaseActionRunner
from passport.backend.core.serializers.persistent_track import PersistentTrackCleanupQuery


class BaseSerializeActionRunner(BaseActionRunner):
    def serialize(self, old_snapshot, new_snapshot, diff=None):
        raise NotImplementedError()


def run_persistent_tracks_cleanup_query(dbm, limit, offset=0):
    query = PersistentTrackCleanupQuery(limit, offset=offset)

    delete_result = {}

    def _callback(result):
        delete_result['count'] = result.rowcount

    safe_execute_queries([(query, _callback)], engine=dbm.get_engine())

    return delete_result['count']
