# -*- coding: utf-8 -*-

import functools

from passport.backend.core.differ.types import Diff
from six import iteritems


def clean_dict_values(dictionary, clean_map):
    if not dictionary:
        return
    new_dict = {}
    for k, v in iteritems(dictionary):
        cleaner = clean_map.get(k)
        new_dict[k] = cleaner(v) if cleaner else v
    return new_dict


def make_cleaner(type_map):
    return functools.partial(clean_dict_values, clean_map=type_map)


def make_diff_cleaner(type_map):
    cleaner = make_cleaner(type_map)

    def wrapper(diff):
        added, changed, deleted = diff
        return Diff(cleaner(added),
                    cleaner(changed),
                    cleaner(deleted))
    return wrapper


class CallbackResultContainer(object):
    def __init__(self):
        self.args = None
        self.kwargs = None

    def reset(self):
        self.args = None
        self.kwargs = None

    def assign(self, *args, **kwargs):
        self.args = args
        self.kwargs = kwargs

    def __call__(self, *args, **kwargs):
        self.assign(*args, **kwargs)

    @property
    def val(self):
        return self.args[0]

    def __getitem__(self, item):
        if self.args is None:
            raise ValueError('Container is not bound to value')
        if isinstance(item, int):
            return self.args[item]
        else:
            return self.kwargs[item]

    def __str__(self):
        return "Contained %s" % str(self.args)

    def __repr__(self):
        return '<CallbackResultContainer %s>' % str(self.args)
