# -*- coding: utf-8 -*-


class BaseYdbSerializer(object):
    @classmethod
    def from_config(cls, config):
        """
        Создаёт специальным образом сконфигурированный сериализатор.

        Если для сериализации требуется дополнительная информация, её можно
        определить здесь.
        """
        return cls()

    def to_ydb_rows(self, model):
        """
        Преобразует модель в список записей БД. Каждая запись БД -- это
        словарь, ключи которого названия столбцов таблицы, а значения
        соответствующие ключи.

        Например, если чтобы представить модель как две записи в таблице со
        столбцами foo и bar, нужно вернуть

        [
            dict(foo='val1', bar='val2'),
            dict(foo='val3', bar='val4'),
        ]
        """
        raise NotImplementedError()

    def from_ydb_rows(self, ydb_rows):
        """
        Преобразует итератор ydb_rows в модель и возвращает её.

        Метод запрашивает из итератора столько строк, сколько нужно для
        построения одной модели.

        Если в итераторе нет записей, то метод должен вернуть None.

        Если в итераторе есть записи, но их недостаточно для построения одной
        модели, метод должен бросить исключение DataCorruptedYdbSerializerError.
        """
        raise NotImplementedError()
