# -*- coding: utf-8 -*-
from passport.backend.core.models.family import FamilyInvite
from passport.backend.core.serializers.ydb.base import BaseYdbSerializer


class FamilyInviteSerializer(BaseYdbSerializer):
    @classmethod
    def from_config(cls, config):
        return cls()

    def to_ydb_rows(self, model):
        return [{
            'invite_id': model.invite_id,
            'family_id': model._family_id,
            'issuer_uid': model.issuer_uid,
            'create_time': model.create_time,
            'send_method': model.send_method,
            'contact': model.contact,
        }]

    def from_ydb_rows(self, ydb_rows):
        try:
            row = next(ydb_rows)
        except StopIteration:
            return

        return FamilyInvite().parse(row)
