# -*- coding: utf-8 -*-
from passport.backend.core.serializers.ydb.family import FamilyInviteSerializer
from passport.backend.core.serializers.ydb.support_code import SupportCodeSerializer


def to_ydb_rows(model, config=None):
    type_mapper = _type_to_serializer()
    model_type = type(model)
    serializer_cls = type_mapper[model_type.__name__]
    serializer = serializer_cls.from_config(config)
    return serializer.to_ydb_rows(model)


def from_ydb_rows(model_type, ydb_rows, config=None):
    type_mapper = _type_to_serializer()
    serializer_cls = type_mapper[model_type.__name__]
    serializer = serializer_cls.from_config(config)
    return serializer.from_ydb_rows(ydb_rows)


def _type_to_serializer():
    return dict(
        SupportCode=SupportCodeSerializer,
        FamilyInvite=FamilyInviteSerializer,
    )
