# -*- coding: utf-8 -*-
import subprocess

from setuptools import (
    find_packages,
    setup,
)
from setuptools.command.install_lib import install_lib as InstallLibOrig


PREFIX = 'passport_backend_core'


# FIXME: оторвать этот костыль по патчингу импортов после перехода использующих проектов на py3 или
#  иного решения проблемы в https://st.yandex-team.ru/PYTHONCOM-255
class InstallLib(InstallLibOrig):
    def build(self):
        print('Patching imports...')
        command = r'find . -name \*.py -exec sed -i "s/passport\.backend\.core/passport_backend_core/g; s/passport\.backend\.utils/passport_backend_utils/g" {} \;'
        p = subprocess.Popen(command, cwd='.', shell=True, stdout=subprocess.PIPE)
        for line in iter(p.stdout.readline, b''):
            print(line.rstrip())
        print('Imports patched.')
        InstallLibOrig.build(self)


def is_link(s):
    return '://' in s


def find_dependency_links():
    return [line for line in open('./requirements.txt') if is_link(line)]


def find_install_requirements():
    return [line for line in open('./requirements.txt') if not is_link(line)]


setup(
    name='yandex-passport-core',
    version='7.0.0',  # неважно, пакет не будет заливаться в pypi
    author='Passport team',
    author_email='passport-dev@yandex-team.ru',
    package_dir={PREFIX: '.'},
    packages=[
        PREFIX,
    ] + [
        '%s.%s' % (PREFIX, subpackage)
        for subpackage in find_packages(exclude=('tests', 'tests.*'))
    ],
    install_requires=find_install_requirements(),
    extras_require={
        'ldap': [
            'python-ldap==3.3.1',
        ],
        's3': [
            'boto3==1.17.112',
        ],
        'sql': [
            'mysqlclient==1.4.6',
            'SQLAlchemy==1.2.19',
        ],
        'ydb': [
            'kikimrclient==0.3.9',
        ],
    },
    dependency_links=find_dependency_links(),
    cmdclass={
        'install_lib': InstallLib,
    },
)
